/*
   WMI Administrator script. January 8, 2007. v.1.1.

   Copyright (C) 2006-2007 Dmitriy Khudorozhkov
   Modified by Stanley Huang

   This software is provided "as-is", without any express or implied warranty.
   In no event will the author be held liable for any damages arising from the
   use of this software.

   Permission is granted to anyone to use this software for any purpose,
   including commercial applications, and to alter it and redistribute it
   freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
      claim that you wrote the original software. If you use this software
      in a product, an acknowledgment in the product documentation would be
      appreciated but is not required.

   2. Altered source versions must be plainly marked as such, and must not be
      misrepresented as being the original software.

   3. This notice may not be removed or altered from any source distribution.

*/

var wmic = null;
var Args = WScript.Arguments;
var xslfile = null;
var encoding = "UTF-8";

if(Args.length > 0) {
    xslfile = Args(0);
}
if (Args.length > 1) {
     encoding = Args(1);
}

wmic = new WMIcollector("127.0.0.1");
wmic.RunQuery();

function WMIcollector(ips)
{
  // ctor:

  this.ip      = [];
  this.service = [];
  this.curserv = null;
  this.silent  = false;

  if(typeof(ips) == "string")
    this.ip[this.ip.length] = ips;
  else
    if(ips.constructor == Array)
    {
      for(var i = 0; i < ips.length; i++)
      {
        var _ip = ips[i];
        var found = false;

        for(var j = 0; j < this.ip.length; j++)
        {
          if(this.ip[j] == _ip)
          {
            found = true;
            break;
          }
        }

        if(!found)
          this.ip[this.ip.length] = _ip;
      }
    }

  // Public API:

  this.RunQuery = function()
  {
    // SAXreader/MXXMLwriter are used to create & save 'neat' xml files.
    //
    var writer = new ActiveXObject("Msxml2.MXXMLWriter.3.0");

    writer.indent = true;            // write xml in a 'pretty printed'-way
    writer.omitXMLDeclaration = true;

    var reader = new ActiveXObject("Msxml2.SAXXMLReader.3.0");

    reader.contentHandler = writer;
    reader.errorHandler = writer;
    //
    // You can also use 'Msxml2.SAXXMLReader.4.0' and 'Msxml2.MXXMLWriter.4.0'
    // (= more detailed error messages) with MSXML 4.0 (or higher) installed.


      // Note on creating & saving xml files:
      //
      // if you are sure that computers you query return nothing that falls
      // out of an ordinary ASCII charset, you may wish to switch back to
      // saving single-byte data (by switching the last parameter of 'CreateTextFile'
      // to 'false' and changing 'encoding' variable to 'UTF-8', 'iso-8859-1',
      // 'Windows-1250' or anything that fits your locale), thus saving
      // ~50% of disk space.
      //
      // 1st parameter - file name;
      // 2nd parameter - overwrite existing file (true/false);
      // 3rd parameter - create unicode (true) or ASCII(false) file.
      //

      // Change this encoding to any that fits:
      // (having created the unicode file, you should keep it UTF-16)
      //

      // Main call:
      var result = this._collectAll("127.0.0.1");
      reader.parse(result.xml);
      WScript.Echo("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
      if (xslfile) WScript.Echo("<?xml-stylesheet type=\"text/xsl\" href=\"" + xslfile + "\"?>");
      WScript.Echo(writer.output);
  }

  this.SetSilentMode = function(issilent) { this.silent = issilent; }

  // String helper functions:

  this._trim = function(src)
  {
    var str_src = String(src);

    // Leading spaces:
    var empty = true;
    for(var l = 0; l < str_src.length; l++)
    {
      if(str_src.charAt(l) != " ")
      {
        empty = false;
        break;
      }
    }

    if(empty) return "";

    // Trailing spaces:
    for(var t = str_src.length - 1; t >= 0; t--)
    {
      if(str_src.charAt(t) != " ")
        break;
    }

    return str_src.substring(l, t + 1);
  }

  this._isempty = function(str)
  {
    if((String(str) == "null") || (this._trim(String(str)) == ""))
      return true;

    return false;
  }

  // XML helper functions:

  this._xmlSetAttribute = function(doc, node, attributeName, attributeValue)
  {
    var Attribute = doc.createAttribute(attributeName);
    var AttributeText = doc.createTextNode(this._trim(attributeValue));

    Attribute.appendChild(AttributeText);
    node.setAttributeNode(Attribute);
  }

  this._xmlCreateChildNode = function(doc, parent, nodeName)
  {
    var Element = doc.createElement(nodeName);

    parent.appendChild(Element);

    return Element;
  }

  this._xmlCreateChildNodeWithAttribute = function(doc, parent, nodeName, attributeName, attributeValue)
  {
    var Element = doc.createElement(nodeName);

    parent.appendChild(Element);

    this._xmlSetAttribute(doc, Element, attributeName, String(attributeValue));

    return Element;
  }

  this._xmlCreateChildTextNode = function(doc, parent, nodeName, nodeContent)
  {
    var str = this._trim(String(nodeContent));

    if(this._isempty(str)) return null;

    var Element = doc.createElement(nodeName);
    var ElementText = doc.createTextNode(str);

    parent.appendChild(Element);
    Element.appendChild(ElementText);

    return Element;
  }

  this._xmlCreateChildTextNodeWithAttribute = function(doc, parent, nodeName, nodeContent, attributeName, attributeValue)
  {
    var str = this._trim(String(nodeContent));

    if(this._isempty(str)) return null;

    var Element = doc.createElement(nodeName);
    var ElementText = doc.createTextNode(str);

    parent.appendChild(Element);
    Element.appendChild(ElementText);

    this._xmlSetAttribute(doc, Element, attributeName, attributeValue);

    return Element;
  }

  // WMI setup & query routines:

  this._SetupService = function(ip)
  {
    if(!this.service[ip])
        this.service[ip] = GetObject("winmgmts:{impersonationLevel=impersonate}!//" + ip + "/root/cimv2");

    this.curserv = this.service[ip];
  }

  this._ExecQuery = function(className)
  {
    return this.curserv.ExecQuery("Select * from " + className);
  }

  this._ExecQueryWithWhereClause = function(className, whereExpression)
  {
    return this.curserv.ExecQuery("Select * from " + className + " Where " + whereExpression);
  }

  // Primary data collection functions:

  this._collectAll = function(ip)
  {
    var xmlDoc = new ActiveXObject("Msxml2.DOMDocument");
    var root = xmlDoc.createElement("Root");
    xmlDoc.appendChild(root);

    /*
    var meta = this._xmlCreateChildNode(xmlDoc, root, "Metadata");
    this._xmlCreateChildTextNode(xmlDoc, meta, "IP", ip);

    var dt = new Date();
    this._xmlCreateChildTextNode(xmlDoc, meta, "Date", (dt.getMonth() + 1) + "/" + dt.getDate() + "/" + dt.getFullYear());
    this._xmlCreateChildTextNode(xmlDoc, meta, "Time", (dt.getHours() < 10 ? "0" + dt.getHours() : dt.getHours()) + ":" +
                                                 (dt.getMinutes() < 10 ? "0" + dt.getMinutes() : dt.getMinutes()) + ":" +
                                                 (dt.getSeconds() < 10 ? "0" + dt.getSeconds() : dt.getSeconds()));
    */

    this._SetupService(ip);

    var hard = this._collectHardwareInfo().firstChild;
    root.appendChild(hard);

    var soft = this._collectSoftwareInfo(ip).firstChild;
    root.appendChild(soft);

    return xmlDoc;
  }

  this._collectHardwareInfo = function()
  {
    var xmlDoc = new ActiveXObject("Msxml2.DOMDocument");
    var root = xmlDoc.createElement("Hardware");
    xmlDoc.appendChild(root);

    var result = this._collectBaseBoardInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectProcessorInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectBiosInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectMemoryInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectDiskDrivesInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectCDROMInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectFloppyInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectTapeDriveInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectIdeControllerInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectScsiControllerInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collect1394ControllerInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectUsbControllerInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPcmciaControllerInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectSerialPortInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectParallelPortInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPortConnectorsInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectIrDeviceInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectNetworkAdapterInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectDisplayInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectVideoAdapterInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectKeyboardInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPointingDeviceInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectSoundInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPrinterInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPOTSModemInfo();
    if (result) root.appendChild(result.firstChild);

    /* Cooling devices: */
    result = this._collectFanInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectHeatPipeInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectRefrigerationInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectSystemEnclosureInfo();
    if (result) root.appendChild(result.firstChild);

    /* Power supply devices: */
    result = this._collectBatteryInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPortableBatteryInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectUPSInfo();
    if (result) root.appendChild(result.firstChild);

    return xmlDoc;
  }

  this._collectSoftwareInfo = function(ip)
  {
    var xmlDoc = new ActiveXObject("Msxml2.DOMDocument");
    var root = xmlDoc.createElement("Software");
    xmlDoc.appendChild(root);

    var result = this._collectComputerSystemInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectOsInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectOSBootInfo();
    if (result) root.appendChild(result.firstChild);

    /*
    result = this._collectOSRecoveryInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectQFEInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectODBCDataSourceInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectODBCDriverInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectODBCTranslatorInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectUserInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectGroupInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectLogonSessionInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectNetworkLoginProfileInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectProductInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectNetworkProtocolInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectTimeInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectTimeZoneInfo();
    if (result) root.appendChild(result.firstChild);

    result = this._collectPingData(ip);
    if (result) root.appendChild(result.firstChild);
   */ 

    result = this._collectCodecInfo();
    if (result) root.appendChild(result.firstChild);

    return xmlDoc;
  }

  // Hardware monitoring:

  this._collect1394ControllerInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_1394Controller"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "IEEE 1394 Controllers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "IEEE 1394 Controller" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectBaseBoardInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_BaseBoard"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    // Anyone seen a desktop with multiple baseboards?
    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Base Boards");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Base board" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        if(Obj.ConfigOptions != null)
        {
          var config_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "Config", "name", "Configuration of the jumpers and switches");

          var i_count = 1;
          var cs = Obj.ConfigOptions.toArray();
          var cc = new Enumerator(cs);

          for (; !cc.atEnd(); cc.moveNext())
          {
            var conf_obj = cc.item();
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "Option" + String(i_count), String(conf_obj), "name", "Option " + String(i_count));

            i_count++;
          }
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HostingBoard", Obj.HostingBoard, "name", "Is motherboard?");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Model", Obj.Model);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Product", Obj.Product);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "RequiresDaughterBoard", Obj.RequiresDaughterBoard, "name", "Requires Daughterboard");
        this._xmlCreateChildTextNode(xmlDoc, root, "SerialNumber", Obj.SerialNumber);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNode(xmlDoc, root, "Version", Obj.Version);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectProcessorInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Processor"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Processors");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Processor" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Architecture", this._translate_processor_architecture(Obj.Architecture));
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CpuStatus", this._translate_processor_status(Obj.CpuStatus), "name", "CPU status");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CurrentClockSpeed", Obj.CurrentClockSpeed, "name", "Current clock speed, MHz");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CurrentVoltage", Obj.CurrentVoltage, "name", "Current voltage, V");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Family", this._translate_processor_family(Obj.Family));
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxClockSpeed", Obj.MaxClockSpeed, "name", "Maximum clock speed, MHz");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProcessorId", Obj.ProcessorId, "name", "Processor ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProcessorType", this._translate_processor_type(Obj.ProcessorType), "name", "Processor type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Revision", Obj.Revision);
        this._xmlCreateChildTextNode(xmlDoc, root, "Role", Obj.Role);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SocketDesignation", Obj.SocketDesignation, "name", "Socket type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNode(xmlDoc, root, "Version", Obj.Version);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectBiosInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_BIOS"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "BIOSs");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "BIOS" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "IdentificationCode", Obj.IdentificationCode, "name", "Identification code");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ReleaseDate", this._translate_date(Obj.ReleaseDate), "name", "Release date");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNode(xmlDoc, root, "Version", Obj.Version);

        if(Obj.BiosCharacteristics != null)
        {
          var char_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "BIOSCharacteristics", "name", "BIOS Features");

          var i_count = 1;
          var chars_ar = Obj.BiosCharacteristics.toArray();
          var chars_en = new Enumerator(chars_ar);

          for (; !chars_en.atEnd(); chars_en.moveNext())
          {
            var ch_obj = chars_en.item();
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, char_node, "Characteristic_" + String(i_count), this._translate_bios_feats(ch_obj), "name", "Feature " + String(i_count));

            i_count++;
          }
        }

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectSoundInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_SoundDevice"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Sound devices");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Sound device" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProductName", Obj.ProductName, "name", "Product name");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectMemoryInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_PhysicalMemory"));

      var xmlDoc = null, colItem = null, numItems = 0;

      for (; !fc.atEnd(); fc.moveNext())
        numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Physical Memory Banks");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Memory Bank" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BankLabel", Obj.BankLabel, "name", "Bank label");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Capacity", Obj.Capacity, "name", "Capacity, bytes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FormFactor", this._translate_memory_form_factor(Obj.FormFactor), "name", "Form factor");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HotSwappable", Obj.HotSwappable, "name", "Is hot-swappable?");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MemoryType", this._translate_memory_type(Obj.MemoryType), "name", "Memory type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Model", Obj.Model);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SerialNumber", Obj.SerialNumber, "name", "Serial number");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Speed", Obj.Speed, "name", "Speed, MHz");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPortConnectorsInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_PortConnector"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Port Connectors");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Port Connector" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InternalReferenceDesignator", Obj.InternalReferenceDesignator, "name", "Internal name");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PoweredOn", String(Obj.PoweredOn), "name", "Is powered on?");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectUsbControllerInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_USBController"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "USB Conrollers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "USB Controller" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectIdeControllerInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_IDEController"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "IDE Controllers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "IDE Controller" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxNumberControlled", Obj.MaxNumberControlled, "name", "Maximum number of directly addressable devices supported");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProtocolSupported", this._translate_protocol_supported(Obj.ProtocolSupported), "name", "Protocol supported");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectScsiControllerInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_SCSIController"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "SCSI Controllers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "SCSI Controller" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriverName", Obj.DriverName, "name", "Driver name");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HardwareVersion", Obj.HardwareVersion, "name", "Hardware version");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxTransferRate", Obj.MaxTransferRate, "name", "Maximum transfer rate, bits per second");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProtectionManagement", this._translate_scsi_protection_management(Obj.ProtectionManagement), "name", "Protecton management");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProtocolSupported", this._translate_protocol_supported(Obj.ProtocolSupported), "name", "Protocol supported");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectSerialPortInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_SerialPort"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Serial Ports");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Serial Port" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxBaudRate", Obj.MaxBaudRate, "name", "Maximum baud rate, bits per second");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProtocolSupported", this._translate_protocol_supported(Obj.ProtocolSupported), "name", "Protocol supported");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProviderType", Obj.ProviderType, "name", "Provider type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectParallelPortInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_ParallelPort"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Parallel Ports");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Parallel Port" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectIrDeviceInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_InfraredDevice"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Infrared Devices");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Infrared Device" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPcmciaControllerInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_PCMCIAController"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "PCMCIA Controllers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "PCMCIA Controller" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectNetworkAdapterInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_NetworkAdapter"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Network Adapters");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Network Adapter" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AdapterType", Obj.AdapterType, "name", "Adapter type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);

        var nc = new Enumerator(this._ExecQueryWithWhereClause("Win32_NetworkAdapterConfiguration", "Index=" + Obj.Index));
        for (; !nc.atEnd(); nc.moveNext())
        {
          var conf_obj = nc.item();
          var conf_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "Configuration", "name", "Adapter configuration:");

          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DatabasePath", conf_obj.DatabasePath, "name", "Path to standard Internet database files");

          if(conf_obj.DefaultIPGateway != null)
          {
            var gate_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, conf_node, "DefaultIPGateways", "name", "Default IP gateways:");

            var i_count = 1;
            var dips = conf_obj.DefaultIPGateway.toArray();
            var dipc = new Enumerator(dips);

            for (; !dipc.atEnd(); dipc.moveNext())
            {
              var dip_obj = dipc.item();
              this._xmlCreateChildTextNode(xmlDoc, gate_node, "DefaultIPGateway_" + String(i_count), String(dip_obj));

              i_count++;
            }
          }

          this._xmlCreateChildTextNode(xmlDoc, conf_node, "Description", conf_obj.Description);
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DHCPEnabled", conf_obj.DHCPEnabled, "name", "DHCP enabled");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DHCPLeaseExpires", this._translate_date(conf_obj.DHCPLeaseExpires), "name", "DHCP lease expires");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DHCPLeaseObtained", this._translate_date(conf_obj.DHCPLeaseObtained), "name", "DHCP lease obtained");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DHCPServer", conf_obj.DHCPServer, "name", "DHCP server");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DNSDomain", conf_obj.DNSDomain, "name", "DNS domain");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DNSEnabledForWINSResolution", conf_obj.DNSEnabledForWINSResolution, "name", "DNS enabled for WINS resolution");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "DNSHostName", conf_obj.DNSHostName, "name", "DNS host name");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "IPEnabled", conf_obj.IPEnabled, "name", "IP enabled");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "IPFilterSecurityEnabled", conf_obj.IPFilterSecurityEnabled, "name", "IP packet filtering enabled");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "IPPortSecurityEnabled", conf_obj.IPPortSecurityEnabled, "name", "IP port security enabled");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "IPUseZeroBroadcast", conf_obj.IPUseZeroBroadcast, "name", "IP uses zero broadcast");

          if(conf_obj.IPXEnabled == true)
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "IPXAddress", conf_obj.IPXAddress, "name", "IPX address");

          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "IPXEnabled", conf_obj.IPXEnabled, "name", "IPX enabled");

/*
          if((Obj.ServiceName == "") | (Obj.ServiceName == undefined) | (Obj.ServiceName == "null"))
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "ServiceName", conf_obj.ServiceName, "name", "Service name of the network adapter");
*/

          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "TcpipNetbiosOptions", conf_obj.TcpipNetbiosOptions, "name", "NetBIOS over TCP/IP");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "TcpNumConnections", conf_obj.TcpNumConnections, "name", "Maximum Number of connections");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "WINSEnableLMHostsLookup", conf_obj.WINSEnableLMHostsLookup, "name", "Local lookup files are used for WINS resoluton");

          if(conf_obj.WINSEnableLMHostsLookup == true)
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "WINSHostLookupFile", conf_obj.WINSHostLookupFile, "name", "Lookup file path");

          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "WINSPrimaryServer", conf_obj.WINSPrimaryServer, "name", "WINS primary server");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, conf_node, "WINSSecondaryServer", conf_obj.WINSSecondaryServer, "name", "WINS secondary server");

          if(conf_obj.IPAddress != null)
          {
            var addr_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, conf_node, "IPAddresses", "name", "IP addresses:");

            var i_count = 1;
            var ips = conf_obj.IPAddress.toArray();
            var ipc = new Enumerator(ips);

            for (; !ipc.atEnd(); ipc.moveNext())
            {
              var ip_obj = ipc.item();
              this._xmlCreateChildTextNodeWithAttribute(xmlDoc, addr_node, "Ip" + String(i_count), String(ip_obj), "name", "IP Address " + String(i_count));

              i_count++;
            }
          }

          if(conf_obj.IPSubnet != null)
          {
            var subnet_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, conf_node, "IPSubnetMasks", "name", "IP subnet masks:");

            var i_count = 1;
            var ipss = conf_obj.IPSubnet.toArray();
            var ipsc = new Enumerator(ipss);

            for (; !ipsc.atEnd(); ipsc.moveNext())
            {
              var ips_obj = ipsc.item();
              this._xmlCreateChildTextNodeWithAttribute(xmlDoc, subnet_node , "Mask" + String(i_count), String(ips_obj), "name", "Subnet mask " + String(i_count));

              i_count++;
            }
          }
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MACAddress", Obj.MACAddress, "name", "MAC address");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxSpeed", Obj.MaxSpeed, "name", "Maximum transfer speed, bits per second");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NetConnectionID", Obj.NetConnectionID, "name", "Name of network connection");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NetConnectionStatus", this._translate_net_connection_status(Obj.NetConnectionStatus), "name", "Status of the network connection");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ServiceName", Obj.ServiceName, "name", "Service name of the network adapter");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Speed", Obj.Speed, "name", "Current transfer speed, bits per second");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectDisplayInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_DesktopMonitor"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Desktop Monitors");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Desktop Monitor" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DisplayType", Obj.DisplayType, "name", "Display type");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MonitorManufacturer", Obj.MonitorManufacturer, "name", "Manufacturer");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MonitorType", Obj.MonitorType, "name", "Monitor type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PixelsPerXLogicalInch", Obj.PixelsPerXLogicalInch, "name", "Resolution along the X axis, pixels per inch");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PixelsPerYLogicalInch", Obj.PixelsPerYLogicalInch, "name", "Resolution along the Y axis, pixels per inch");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ScreenHeight", Obj.ScreenHeight, "name", "Logical height of the display, pixels");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ScreenWidth", Obj.ScreenWidth, "name", "Logical width of the display, pixels");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectVideoAdapterInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_VideoController"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Video Adapters");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Video Adapter" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AdapterDACType", Obj.AdapterDACType, "name", "Adapter DAC type");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AdapterRAM", Obj.AdapterRAM, "name", "Ammount of onboard RAM, bytes");
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CurrentRefreshRate", Obj.CurrentRefreshRate, "name", "Current refresh rate, Hz");
        this._xmlCreateChildTextNode(xmlDoc, root, "Description", Obj.Description);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriverDate", this._translate_date(Obj.DriverDate), "name", "Driver date");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriverVersion", Obj.DriverVersion, "name", "Driver version");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxRefreshRate", Obj.MaxRefreshRate, "name", "Maximum refresh rate, Hz");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MinRefreshRate", Obj.MinRefreshRate, "name", "Minimum refresh rate, Hz");
        this._xmlCreateChildTextNode(xmlDoc, root, "Monochrome", Obj.Monochrome);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProtocolSupported", this._translate_protocol_supported(Obj.ProtocolSupported), "name", "Protocol supported");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "VideoArchitecture", this._translate_video_architecture(Obj.VideoArchitecture), "name", "Video architecture");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "VideoMemoryType", this._translate_video_memory_type(Obj.VideoMemoryType), "name", "Video memory type");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "VideoModeDescription", Obj.VideoModeDescription, "name", "Video mode description");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "VideoProcessor", Obj.VideoProcessor, "name", "Video processor");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectCDROMInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_CDROMDrive"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "CD-ROM Drives");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "CD-ROM Drive" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Drive", Obj.Drive);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriveIntegrity", Obj.DriveIntegrity, "name", "Files can be accurately read from the CD device");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxMediaSize", Obj.MaxMediaSize, "name", "Maximum media size supported, kilobytes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MediaType", Obj.MediaType, "name", "Media type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Size", Obj.Size);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectDiskDrivesInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_DiskDrive"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Disk Drives");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Disk Drive" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BytesPerSector", Obj.BytesPerSector, "name", "Bytes per sector");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Index", Obj.Index);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InterfaceType", Obj.InterfaceType, "name", "Interface type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxMediaSize", Obj.MaxMediaSize, "name", "Maximum media size supported, kilobytes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MediaType", Obj.MediaType, "name", "Media type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Model", Obj.Model);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Size", Obj.Size, "name", "Capacity, bytes");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectFloppyInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_FloppyDrive"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Floppy Disk Drives");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Floppy Disk Drive" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectTapeDriveInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_TapeDrive"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Tape Drives");
      }

      var i = 1;
      for (fc.moveFirst();!fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Tape Drive" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Compression", this._translate_true_false(Obj.Compression), "name", "Hardware data compression is enabled");

        if(Obj.Compression == 1)
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CompressionMethod", Obj.CompressionMethod, "name", "Algorithm or tool used by the device to support compression");

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ECC", this._translate_true_false(Obj.ECC), "name", "Device supports hardware error correction");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ErrorMethodology", Obj.ErrorMethodology, "name", "Type of error detection and correction supported by device");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FeaturesHigh", Obj.FeaturesHigh, "name", "High-order 32 bits of the device features flag");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FeaturesLow", Obj.FeaturesLow, "name", "Low-order 32 bits of the device features flag");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Id", Obj.Id, "name", "Identifying name");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxMediaSize", Obj.MaxMediaSize, "name", "Maximum size, in kilobytes, of media supported by device");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MediaType", Obj.MediaType, "name", "Media type used by (or accessed by) this device");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfMediaSupported", Obj.NumberOfMediaSupported, "name", "Maximum number of individual media which can be supported or inserted in the media access device");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PNPDeviceID", Obj.PNPDeviceID, "name", "Windows Plug and Play device identifier");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ReportSetMarks", this._translate_true_false(Obj.ReportSetMarks), "name", "Setmark reporting is enabled");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        if(Obj.Capabilities != null)
        {
          var cap_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "Capabilities", "name", "Device capabilities:");

          var c_count = 1;
          var cps = Obj.Capabilities.toArray();
          var cpc = new Enumerator(cps);

          for (; !cpc.atEnd(); cpc.moveNext())
          {
            var cp_obj = cpc.item();
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, cap_node, "Cap" + String(c_count), this._translate_conseq_capabilities(cp_obj), "name", "Capability " + String(c_count));

            c_count++;
          }
        }

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectKeyboardInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Keyboard"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Keyboards");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Keyboard" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Layout", Obj.Layout);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfFunctionKeys", Obj.NumberOfFunctionKeys, "name", "Number of function keys");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPointingDeviceInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_PointingDevice"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Pointing Devices");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Pointing Device" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceInterface", this._translate_mouse_interface(Obj.DeviceInterface), "name", "Device interface");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HardwareType", Obj.HardwareType, "name", "Hardware type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfButtons", Obj.NumberOfButtons, "name", "Number of buttons");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PointingType", this._translate_mouse_type(Obj.PointingType), "name", "Pointing device type");
        this._xmlCreateChildTextNode(xmlDoc, root, "Resolution", Obj.Resolution);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SampleRate", Obj.SampleRate, "name", "Sampling rate, Hz");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPrinterInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Printer"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Printers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Printer" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriverName", Obj.DriverName, "name", "Driver name");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Network", Obj.Network, "name", "Is network printer?");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PortName", Obj.PortName, "name", "Port that is used to transmit data to a printer");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PrinterStatus", this._translate_printer_status(Obj.PrinterStatus), "name", "Status of printer");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PrintProcessor", Obj.PrintProcessor, "name", "Name of the print spooler that handles print jobs");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ServerName", Obj.ServerName, "name", "Name of the server that controls the printer");

        if(Obj.Attributes != null)
        {
          var attrib_node = this._xmlCreateChildNode(xmlDoc, root, "Attributes");

          if(Obj.Attributes & 0x1) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute1", "true", "name", "Print jobs are buffered and queued");
          if(Obj.Attributes & 0x2) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute2", "true", "name", "Document to be sent directly to the printer");
          if(Obj.Attributes & 0x4) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute3", "true", "name", "Default printer on a computer");
          if(Obj.Attributes & 0x8) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute4", "true", "name", "Available as a shared network resource");
          if(Obj.Attributes & 0x10) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute5", "true", "name", "Attached to a network");
          if(Obj.Attributes & 0x20) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute6", "true", "name", "Hidden from some users on the network");
          if(Obj.Attributes & 0x40) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute7", "true", "name", "Directly connected to a computer");
          if(Obj.Attributes & 0x80) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute8", "true", "name", "Enable the queue on the printer if available");
          if(Obj.Attributes & 0x100) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute9", "true", "name", "Spooler should not delete documents after they are printed");
          if(Obj.Attributes & 0x200) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute10", "true", "name", "Start jobs that are finished spooling first");
          if(Obj.Attributes & 0x400) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute11", "true", "name", "Queue print jobs when a printer is not available");
          if(Obj.Attributes & 0x800) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute12", "true", "name", "Enable bi-directional printing");
          if(Obj.Attributes & 0x1000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute13", "true", "name", "Allow only raw data type jobs to be spooled");
          if(Obj.Attributes & 0x2000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, attrib_node, "Attribute14", "true", "name", "Published in the network directory service");
        }

        var cc = new Enumerator(this._ExecQueryWithWhereClause("Win32_PrinterConfiguration", "Name=\"" + Obj.Name + "\""));
        for (cc.moveFirst(); !cc.atEnd(); cc.moveNext())
        {
          var conf_obj = cc.item();
          var config_node = this._xmlCreateChildNode(xmlDoc, root, "Configuration");

          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "Collate", conf_obj.Collate, "name", "Pages that are printed should be collated");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "Color", this._translate_print_color(conf_obj.Color), "name", "Color mode");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "DitherType", this._translate_print_dither_type(conf_obj.DitherType), "name", "Dither type of the printer");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "DriverVersion", conf_obj.DriverVersion, "name", "Version number of the printer driver");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "Duplex", conf_obj.Duplex, "name", "Printing is done on both sides");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "HorizontalResolution", conf_obj.HorizontalResolution, "name", "Print resolution along the X axis (width), dots per inch");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "VerticalResolution", conf_obj.VerticalResolution, "name", "Print resolution along the Y axis (height), dots per inch");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "ICMIntent", this._translate_print_icm_intent(conf_obj.ICMIntent), "name", "Color matching method");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "ICMMethod", this._translate_print_icm_method(conf_obj.ICMMethod), "name", "How ICM is handled");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "MediaType", this._translate_print_media_type(conf_obj.MediaType), "name", "Type of media being printed on");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "Orientation", this._translate_print_orientation(conf_obj.Orientation), "name", "Printing orientation of the paper");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "PaperSize", conf_obj.PaperSize, "name", "Size of the paper");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "Scale", conf_obj.Scale, "name", "Factor by which the printed output is to be scaled, %");
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, config_node, "TTOption", this._translate_print_true_type_option(conf_obj.TTOption), "name", "How TrueType(r) fonts should be printed");
        }

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectBatteryInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Battery"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Batteries");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Battery" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BatteryRechargeTime", Obj.BatteryRechargeTime, "name", "Battery recharge time");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BatteryStatus", Obj.BatteryStatus, "name", "Status of battery");
        this._xmlCreateChildTextNode(xmlDoc, root, "Chemistry", Obj.Chemistry);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DesignCapacity", Obj.DesignCapacity, "name", "Design capacity");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DesignVoltage", Obj.DesignVoltage, "name", "Design voltage");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "EstimatedChargeRemaining", Obj.EstimatedChargeRemaining, "name", "Estimated time until battery is fully recharged");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "EstimatedRunTime", Obj.EstimatedRunTime, "name", "Estimate in minutes of the time to battery charge depletion");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ExpectedBatteryLife", Obj.ExpectedBatteryLife, "name", "Amount of time it takes to completely drain the battery after it has been fully charged");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ExpectedLife", Obj.ExpectedLife, "name", "Battery's expected lifetime");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FullChargeCapacity", Obj.FullChargeCapacity, "name", "Full charge capacity");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxRechargeTime", Obj.MaxRechargeTime, "name", "Maximum time, in minutes, to fully charge the battery");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TimeOnBattery", Obj.TimeOnBattery, "name", "Elapsed time in seconds since UPS last switched to battery power");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TimeToFullCharge", Obj.TimeToFullCharge, "name", "Remaining time to charge the battery fully");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPortableBatteryInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_PortableBattery"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Portable Batteries");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Portable Battery" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BatteryRechargeTime", Obj.BatteryRechargeTime, "name", "Battery recharge time");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BatteryStatus", Obj.BatteryStatus, "name", "Status of battery");
        this._xmlCreateChildTextNode(xmlDoc, root, "Chemistry", Obj.Chemistry);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DesignCapacity", Obj.DesignCapacity, "name", "Design capacity");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DesignVoltage", Obj.DesignVoltage, "name", "Design voltage");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "EstimatedChargeRemaining", Obj.EstimatedChargeRemaining, "name", "Estimated time until battery is fully recharged");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "EstimatedRunTime", Obj.EstimatedRunTime, "name", "Estimate in minutes of the time to battery charge depletion");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ExpectedBatteryLife", Obj.ExpectedBatteryLife, "name", "Amount of time it takes to completely drain the battery after it has been fully charged");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ExpectedLife", Obj.ExpectedLife, "name", "Battery's expected lifetime");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FullChargeCapacity", Obj.FullChargeCapacity, "name", "Full charge capacity");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxRechargeTime", Obj.MaxRechargeTime, "name", "Maximum time, in minutes, to fully charge the battery");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TimeOnBattery", Obj.TimeOnBattery, "name", "Elapsed time in seconds since UPS last switched to battery power");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TimeToFullCharge", Obj.TimeToFullCharge, "name", "Remaining time to charge the battery fully");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectUPSInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_UninterruptiblePowerSupply"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "UPS Devices");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "UPS Device" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BatteryInstalled", Obj.BatteryInstalled, "name", "Battery installed");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CanTurnOffRemotely", Obj.CanTurnOffRemotely, "name", "UPS can be turned off remotely");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "EstimatedChargeRemaining", Obj.EstimatedChargeRemaining, "name", "Estimated time until UPS's battery is fully recharged");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "EstimatedRunTime", Obj.EstimatedRunTime, "name", "Estimated time, in minutes, to battery/generator depletion");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FirstMessageDelay", Obj.FirstMessageDelay, "name", "Length of time between initial power failure and the first message sent to users");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "IsSwitchingSupply", Obj.IsSwitchingSupply, "name", "UPS is a switching (as opposed to linear) supply");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LowBatterySignal", Obj.LowBatterySignal, "name", "Has a low battery signal");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MessageInterval", Obj.MessageInterval, "name", "Length of time between messages sent to users");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PowerFailSignal", Obj.PowerFailSignal, "name", "UPS has a power failure signal");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "RemainingCapacityStatus", Obj.RemainingCapacityStatus, "name", "Capacity remaining in the UPS' batteries and generator");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TimeOnBackup", Obj.TimeOnBackup, "name", "Elapsed time, in seconds, after the UPS last switched to battery power/generator/was restarted");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TotalOutputPower", Obj.TotalOutputPower, "name", "Total output power of the UPS");

        if(Obj.IsSwitchingSupply == true)
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TypeOfRangeSwitching", Obj.TypeOfRangeSwitching, "name", "Type of input voltage range switching implemented");

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "UPSPort", Obj.UPSPort, "name", "Name of the serial port to which the UPS is connected");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectFanInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Fan"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Cooling fans");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Cooling fan" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ActiveCooling", Obj.ActiveCooling, "name", "Device provides active cooling");
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PNPDeviceID", Obj.PNPDeviceID, "name", "Windows Plug and Play device identifier");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "VariableSpeed", Obj.VariableSpeed, "name", "Fan supports variable speeds");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectHeatPipeInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_HeatPipe"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Heat pipe cooling devices");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Heat pipe cooling device" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ActiveCooling", Obj.ActiveCooling, "name", "Device provides active cooling");
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PNPDeviceID", Obj.PNPDeviceID, "name", "Windows Plug and Play device identifier");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectRefrigerationInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Refrigeration"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Refrigeration devices");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Refrigeration device" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ActiveCooling", Obj.ActiveCooling, "name", "Device provides active cooling");
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PNPDeviceID", Obj.PNPDeviceID, "name", "Windows Plug and Play device identifier");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPOTSModemInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_POTSModem"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Plain Old Telephone Service (POTS) modems");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", ((numItems > 1) ? "Modem" : "Plain Old Telephone Service (POTS) modem") + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AnswerMode", this._translate_answer_mode(Obj.AnswerMode), "name", "Auto-answer/call-back setting for the modem");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AttachedTo", Obj.AttachedTo, "name", "Port to which this modem is attached");
        this._xmlCreateChildTextNode(xmlDoc, root, "Availability", this._translate_availability(Obj.Availability));
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceID", Obj.DeviceID, "name", "Device ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DeviceType", Obj.DeviceType, "name", "Physical type of the modem");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DialType", this._translate_dial_tone(Obj.DialType), "name", "Type of dialing method used");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriverDate", this._translate_date(Obj.DriverDate), "name", "Date of the modem driver");
        this._xmlCreateChildTextNode(xmlDoc, root, "Model", Obj.Model);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ModemInfPath", Obj.ModemInfPath, "name", "Path to this modem's .inf file");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PortSubClass", this._translate_modem_port(Obj.PortSubClass), "name", "Definition of the port used for this modem");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Prefix", Obj.Prefix, "name", "Dialing prefix used to access an outside line");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ProviderName", Obj.ProviderName, "name", "Provider name");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "RingsBeforeAnswer", Obj.RingsBeforeAnswer, "name", "Number of rings before the modem answers an incoming call");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StringFormat", Obj.StringFormat, "name", "Type of characters used for text passed through the modem");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsCallback", Obj.SupportsCallback, "name", "Modem supports call-back");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TimeOfLastReset", this._translate_date(Obj.TimeOfLastReset), "name", "Date and time the modem was last reset");

        if(Obj.CountriesSupported != null)
        {
          var cs_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "CountriesSupported", "name", "Countries supported:");

          var c_count = 1;
          var csps = Obj.CountriesSupported.toArray();
          var cspc = new Enumerator(csps);

          for (; !cspc.atEnd(); cspc.moveNext())
          {
            var cs_obj = cspc.item();
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, cs_node, "Country" + String(c_count), String(cs_obj), "name", "Country " + String(c_count));

            c_count++;
          }
        }

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectSystemEnclosureInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_SystemEnclosure"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "System enclosures");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "System enclosure" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AudibleAlarm", Obj.AudibleAlarm, "name", "Frame is equipped with an audible alarm");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CableManagementStrategy", Obj.CableManagementStrategy, "name", "How the various cables are connected and bundled for the frame");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HeatGeneration", Obj.HeatGeneration, "name", "Amount of heat generated by the chassis, BTU/hour");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LockPresent", Obj.LockPresent, "name", "Frame is protected with a lock");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Model", Obj.Model);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfPowerCords", Obj.NumberOfPowerCords, "name", "Number of power cords which must be connected to the chassis, for all the components to operate");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Tag", Obj.Tag, "name", "Unique identifier of the system enclosure");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "VisibleAlarm", Obj.VisibleAlarm, "name", "Equipment includes a visible alarm");

        if(Obj.ChassisTypes != null)
        {
          var ct_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "ChassisTypes", "name", "Chassis types:");

          var ct_count = 1;
          var ctps = Obj.ChassisTypes.toArray();
          var ctpc = new Enumerator(ctps);

          for (; !ctpc.atEnd(); ctpc.moveNext())
          {
            var ct_obj = ctpc.item();
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, ct_node, "ChassisType" + String(ct_count), this._translate_chassis_type(String(ct_obj)), "name", "Type " + String(ct_count));

            ct_count++;
          }
        }

        if(Obj.ServicePhilosophy != null)
        {
          var ct_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "ServicePhilosophy", "name", "Service philosophy:");

          var ct_count = 1;
          var ctps = Obj.ServicePhilosophy.toArray();
          var ctpc = new Enumerator(ctps);

          for (; !ctpc.atEnd(); ctpc.moveNext())
          {
            var ct_obj = ctpc.item();
            this._xmlCreateChildTextNodeWithAttribute(xmlDoc, ct_node, "ServiceType" + String(ct_count), this._translate_service_philosophy(String(ct_obj)), "name", "Service type " + String(ct_count));

            ct_count++;
          }
        }

        i++;
      }
    }

    return xmlDoc;
  }

  // Software monitoring:

  this._collectUserInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_UserAccount"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "User Accounts");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "User Account" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AccountType", this._translate_user_account_type(Obj.AccountType), "name", "Type of account");
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Disabled", Obj.Disabled, "name", "Is disabled?");
        this._xmlCreateChildTextNode(xmlDoc, root, "Domain", Obj.Domain);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FullName", Obj.FullName, "name", "Full name");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LocalAccount", Obj.LocalAccount, "name", "Is local account?");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Lockout", Obj.Lockout, "name", "Is locked out?");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PasswordChangeable", Obj.PasswordChangeable, "name", "Is password changeble on this account?");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PasswordExpires", Obj.PasswordExpires, "name", "Password expires on this account");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PasswordRequired", Obj.PasswordRequired, "name", "Password is required on this user account");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectGroupInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Group"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Group accounts");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Group account" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Domain", Obj.Domain);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectLogonSessionInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_LogonSession"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Logon Sessions");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Logon Session" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AuthenticationPackage", Obj.AuthenticationPackage, "name", "Authentication subsystem");
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LogonId", Obj.LogonId, "name", "Logon ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LogonType", this._translate_logon_type(Obj.LogonType), "name", "Type of logon");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StartTime", this._translate_date(Obj.StartTime), "name", "Session started");
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectProductInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_Product"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Installed Software");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Software Product" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "IdentifyingNumber", Obj.IdentifyingNumber, "name", "Product ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InstallLocation", Obj.InstallLocation, "name", "Product path");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InstallState", this._translate_software_install_state(Obj.InstallState), "name", "Installed state of the product");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Vendor", Obj.Vendor);
        this._xmlCreateChildTextNode(xmlDoc, root, "Version", Obj.Version);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectCodecInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_CodecFile"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Audio/Video Codecs");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Codec" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Description", Obj.Description);
        this._xmlCreateChildTextNode(xmlDoc, root, "InstallDate", this._translate_date(Obj.InstallDate));
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNode(xmlDoc, root, "Version", Obj.Version);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectNetworkProtocolInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_NetworkProtocol"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Network protocols");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Network Protocol" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ConnectionlessService", Obj.ConnectionlessService, "name", "Protocol supports connectionless service");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "GuaranteesDelivery", Obj.GuaranteesDelivery, "name", "Protocol supports guaranteed delivery of data packets");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "GuaranteesSequencing", Obj.GuaranteesSequencing, "name", "Protocol guarantees sequencing");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MessageOriented", Obj.MessageOriented, "name", "Protocol is message-oriented");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsBroadcasting", Obj.SupportsBroadcasting, "name", "Protocol supports broadcasting");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsConnectData", Obj.SupportsConnectData, "name", "Protocol allows data to be connected across the network");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsDisconnectData", Obj.SupportsDisconnectData, "name", "Protocol allows data to be disconnected across the network");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsEncryption", Obj.SupportsEncryption, "name", "Protocol supports data encryption");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsExpeditedData", Obj.SupportsExpeditedData, "name", "Protocol supports expedited (\"urgent\") data");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsFragmentation", Obj.SupportsFragmentation, "name", "Protocol supports transmitting the data in fragments");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsGracefulClosing", Obj.SupportsGracefulClosing, "name", "Protocol supports two-phase close operations");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsGuaranteedBandwidth", Obj.SupportsGuaranteedBandwidth, "name", "Protocol has a mechanism to maintain a guaranteed bandwidth");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsMulticasting", Obj.SupportsMulticasting, "name", "Protocol supports multicasting");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SupportsQualityofService", Obj.SupportsQualityofService, "name", "Protocol is capable of Quality of Service (QOS) support");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectNetworkLoginProfileInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_NetworkLoginProfile"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Network Login Profiles");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Network Login Profile" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AccountExpires", Obj.AccountExpires, "name", "Account expiration date");

        if((Obj.AuthorizationFlags != null) && (Obj.AuthorizationFlags != 0))
        {
          var aflags_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "AuthorizationFlags", "name", "Resources a user is authorized to use or modify");

          if(Obj.AuthorizationFlags & 0x1) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, aflags_node, "AuthFlag1", "true", "name", "Printer");
          if(Obj.AuthorizationFlags & 0x2) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, aflags_node, "AuthFlag2", "true", "name", "Communication");
          if(Obj.AuthorizationFlags & 0x4) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, aflags_node, "AuthFlag3", "true", "name", "Server");
          if(Obj.AuthorizationFlags & 0x8) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, aflags_node, "AuthFlag4", "true", "name", "Accounts");
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BadPasswordCount", Obj.BadPasswordCount, "name", "Number of times the user entered a bad password when logging on");

        this._xmlCreateChildTextNode(xmlDoc, root, "Comment", Obj.Comment);
        this._xmlCreateChildTextNode(xmlDoc, root, "Description", Obj.Description);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FullName", Obj.FullName, "name", "Full name of the account");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HomeDirectory", Obj.HomeDirectory, "name", "Path to the home directory of the user");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HomeDirectoryDrive", Obj.HomeDirectoryDrive, "name", "Drive letter assigned to the user's home directory");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LastLogoff", this._translate_date(Obj.LastLogoff), "name", "User last logged off the system (time of logoff)");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LastLogon", this._translate_date(Obj.LastLogon), "name", "User last logged on to the system (time of logon)");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LogonHours", Obj.LogonHours, "name", "Times during the week when the user can log on");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LogonServer", Obj.LogonServer, "name", "Name of the server to which logon requests are sent");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaximumStorage", (Obj.MaximumStorage == 4294967295 ? "All available" : Obj.MaximumStorage), "name", "Maximum amount of disk space available to the user, bytes");

        if(this._isempty(Obj.FullName))
          this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Name", Obj.Name, "name", "Account name");

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfLogons", Obj.NumberOfLogons, "name", "Number of successful logons");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PasswordAge", this._translate_pass_age(Obj.PasswordAge), "name", "Length of time a password has been in effect");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PasswordExpires", this._translate_date(Obj.PasswordExpires), "name", "Date/time when the password will expire");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PrimaryGroupId", Obj.PrimaryGroupId, "name", "Relative identifier (RID) of the Primary Global Group for this user");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Privileges", this._translate_privilege(Obj.Privileges), "name", "Level of privilege assigned");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Profile", Obj.Profile, "name", "Path to the user's profile");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ScriptPath", Obj.ScriptPath, "name", "Directory path to the user's logon script");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SettingID", Obj.SettingID, "name", "Setting ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "UnitsPerWeek", Obj.UnitsPerWeek, "name", "Number of time units the week is divided into");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "UserId", Obj.UserId, "name", "Relative identifier (RID) of the user");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "UserType", Obj.UserType, "name", "Type of account");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Workstations", Obj.Workstations, "name", "Names of workstations from which the user can log on");

        if(Obj.Flags != null)
        {
          var flags_node = this._xmlCreateChildNode(xmlDoc, root, "Flags");

          if(Obj.Flags & 0x1) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag1", "true", "name", "Logon Script Was Executed");
          if(Obj.Flags & 0x2) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag2", "true", "name", "Account Is Disabled");
          if(Obj.Flags & 0x8) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag3", "true", "name", "Home Directory Required");
          if(Obj.Flags & 0x10) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag4", "true", "name", "The Account Is Locked Out");
          if(Obj.Flags & 0x20) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag5", "true", "name", "Password Not Required");
          if(Obj.Flags & 0x40) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag6", "true", "name", "Password Can't Change");
          if(Obj.Flags & 0x80) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag7", "true", "name", "Encrypted Test Password Allowed");
          if(Obj.Flags & 0x100) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag8", "true", "name", "Temporary Duplicate Account");
          if(Obj.Flags & 0x200) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag9", "true", "name", "Normal Account");
          if(Obj.Flags & 0x800) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag10", "true", "name", "Interdomain Trust Account");
          if(Obj.Flags & 0x1000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag11", "true", "name", "Workstation Trust Account");
          if(Obj.Flags & 0x2000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag12", "true", "name", "Server Trust Account");
          if(Obj.Flags & 0x10000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag13", "true", "name", "Don't Expire Password");
          if(Obj.Flags & 0x114240) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag14", "true", "name", "MNS Logon Account");
          if(Obj.Flags & 0x40000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag15", "true", "name", "Smartcard Required");
          if(Obj.Flags & 0x80000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag16", "true", "name", "Trusted For Delegation");
          if(Obj.Flags & 0x100000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag17", "true", "name", "Not Delegated");
          if(Obj.Flags & 0x200000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag18", "true", "name", "Use DES Key Only");
          if(Obj.Flags & 0x400000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag19", "true", "name", "Don't Require Preauthorization");
          if(Obj.Flags & 0x800000) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, flags_node, "Flag20", "true", "name", "Password Expired");
        }

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectTimeInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_LocalTime"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Local Time Settings");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Local Time" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Day", Obj.Day);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DayOfWeek", Obj.DayOfWeek, "name", "Day of week");
        this._xmlCreateChildTextNode(xmlDoc, root, "Hour", Obj.Hour);
        this._xmlCreateChildTextNode(xmlDoc, root, "Minute", Obj.Minute);
        this._xmlCreateChildTextNode(xmlDoc, root, "Month", Obj.Month);
        this._xmlCreateChildTextNode(xmlDoc, root, "Quarter", Obj.Quarter);
        this._xmlCreateChildTextNode(xmlDoc, root, "Second", Obj.Second);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "WeekInMonth", Obj.WeekInMonth, "name", "Week in month");
        this._xmlCreateChildTextNode(xmlDoc, root, "Year", Obj.Year);

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectTimeZoneInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_TimeZone"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Time Zone Settings");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Time Zone" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Bias", Obj.Bias, "name", "Bias from UTC, minutes");
        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightBias", Obj.DaylightBias, "name", "Daylight saving time bias, minutes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightName", Obj.DaylightName, "name", "Daylight time zone name");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SettingID", Obj.SettingID, "name", "Setting ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardBias", Obj.StandardBias, "name", "Standard time bias, minutes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardName", Obj.StandardName, "name", "Standard time zone name");

        // All other properties have been 'switched off' - too much space & too little use...
  /*
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightDay", Obj.DaylightDay, "name", "DaylightDayOfWeek of the DaylightMonth when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightDayOfWeek", Obj.DaylightDayOfWeek, "name", "Day of the week when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightHour", Obj.DaylightHour, "name", "Hour of the day when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightMillisecond", Obj.DaylightMillisecond, "name", "Millisecond of of the DaylightSecond when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightMinute", Obj.DaylightMinute, "name", "Minute of the DaylightHour when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightMonth", Obj.DaylightMonth, "name", "Month when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightSecond", Obj.DaylightSecond, "name", "Second of of the DaylightMinute when the transition from standard time to daylight saving time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DaylightYear", Obj.DaylightYear, "name", "Year when daylight saving time is in effect (not required)");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardDay", Obj.StandardDay, "name", "StandardDayOfWeek of the StandardMonth when the transition from daylight saving time to standard time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardDayOfWeek", Obj.StandardDayOfWeek, "name", "Day of the week when the transition from daylight saving time to standard time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardHour", Obj.StandardHour, "name", "Hour of the day when the transition from daylight saving time to standard time occurs on this operating system.");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardMillisecond", Obj.StandardMillisecond, "name", "Millisecond of the StandardSecond when the transition from daylight saving time to standard time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardMinute", Obj.StandardMinute, "name", "Minute of the StandardDay when the transition from daylight saving time to standard time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardMonth", Obj.StandardMonth, "name", "Month when the transition from daylight saving time to standard time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardSecond", Obj.StandardSecond, "name", "Second of the StandardMinute when the transition from daylight saving time to standard time occurs on this operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StandardYear", Obj.StandardYear, "name", "Year when standard time is in effect (not required)");
  */
        i++;
      }
    }

    return xmlDoc;
  }

  this._collectComputerSystemInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_ComputerSystem"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Computer Systems");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Computer System" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BootupState", Obj.BootupState, "name", "Bootup state");

        this._xmlCreateChildTextNode(xmlDoc, root, "Domain", Obj.Domain);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DomainRole", this._translate_domain_role(Obj.DomainRole), "name", "Role of this computer in a domain");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InfraredSupported", Obj.InfraredSupported, "name", "IR port exists on this computer");

        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);
        this._xmlCreateChildTextNode(xmlDoc, root, "Model", Obj.Model);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfProcessors", Obj.NumberOfProcessors, "name", "Number of processors");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PowerManagementSupported", Obj.PowerManagementSupported, "name", "Computer can be power-managed");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PowerState", this._translate_power_state(Obj.PowerState), "name", "Current power state of a computer and its associated operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "PowerSupplyState", this._translate_power_supply_state(Obj.PowerSupplyState), "name", "State of the power supply or supplies when last booted");

        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SystemType", Obj.SystemType, "name", "Computer architecture");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ThermalState", this._translate_power_supply_state(Obj.ThermalState), "name", "Thermal state of the system when last booted");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TotalPhysicalMemory", Obj.TotalPhysicalMemory, "name", "Ammount of physical memory installed, bytes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "UserName", Obj.UserName, "name", "User currently logged on");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "WakeUpType", this._translate_wake_up(Obj.WakeUpType), "name", "Event that causes the system to power up");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectOsInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_OperatingSystem"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Operating Systems");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Operating System" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BootDevice", Obj.BootDevice, "name", "Name of the disk drive from which this OS boots");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BuildNumber", Obj.BuildNumber, "name", "Build number");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BuildType", Obj.BuildType, "name", "Type of build used for this operating system");

        this._xmlCreateChildTextNode(xmlDoc, root, "Caption", Obj.Caption);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CodeSet", Obj.CodeSet, "name", "Code page value in use");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CountryCode", Obj.CountryCode, "name", "Code for the country/region in use");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CurrentTimeZone", Obj.CurrentTimeZone, "name", "Number of minutes the operating system is offset from GMT");

        this._xmlCreateChildTextNode(xmlDoc, root, "Distributed", Obj.Distributed);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ForegroundApplicationBoost", this._translate_application_boost(Obj.ForegroundApplicationBoost), "name", "Increase in priority given to the foreground application");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FreePhysicalMemory", Obj.FreePhysicalMemory, "name", "Physical memory available, kilobytes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FreeVirtualMemory", Obj.FreeVirtualMemory, "name", "Virtual memory  available, kilobytes");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LastBootUpTime", this._translate_date(Obj.LastBootUpTime), "name", "Date/time when the operating system was last booted");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "LocalDateTime", this._translate_date(Obj.LocalDateTime), "name", "Operating system's version of the local date and time of day (valid in the moment of query)");

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Locale", Obj.Locale, "name", "Language identifier in use");
        this._xmlCreateChildTextNode(xmlDoc, root, "Manufacturer", Obj.Manufacturer);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "MaxNumberOfProcesses", (Obj.MaxNumberOfProcesses == -1 ? "Unlimited" : Obj.MaxNumberOfProcesses), "name", "Maximum number of processes the operating system can support");

        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfLicensedUsers", (Obj.NumberOfLicensedUsers == 0 ? "Unlimited" : Obj.NumberOfLicensedUsers), "name", "Number of user licenses");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfProcesses", Obj.NumberOfProcesses, "name", "Number of processes currently running");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "NumberOfUsers", Obj.NumberOfUsers, "name", "Current number of user sessions");

        this._xmlCreateChildTextNode(xmlDoc, root, "Organization", Obj.Organization);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "OSLanguage", this._translate_language_of_os(Obj.OSLanguage), "name", "Language version");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "OSType", this._translate_type_of_os(Obj.OSType), "name", "Type of operating system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "RegisteredUser", Obj.RegisteredUser, "name", "Name of the registered user");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SerialNumber", Obj.SerialNumber, "name", "Serial identification number");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ServicePackMajorVersion", Obj.ServicePackMajorVersion, "name", "Service pack installed, major version number");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ServicePackMinorVersion", Obj.ServicePackMinorVersion, "name", "Service pack installed, minor version number");

        this._xmlCreateChildTextNode(xmlDoc, root, "Status", Obj.Status);

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SystemDevice", Obj.SystemDevice, "name", "Physical disk partition on which the OS is installed");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SystemDirectory", Obj.SystemDirectory, "name", "System directory");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Version", Obj.Version, "name", "Version number");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "WindowsDirectory", Obj.WindowsDirectory, "name", "Windows directory");

        if(Obj.OSProductSuite != null)
        {
          var suite_node = this._xmlCreateChildNodeWithAttribute(xmlDoc, root, "OSProductSuite", "name", "Installed and licensed system product additions");

          if(Obj.OSProductSuite & 0x1) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite1", "installed", "name", "Small Business");
          if(Obj.OSProductSuite & 0x2) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite2", "installed", "name", "Enterprise");
          if(Obj.OSProductSuite & 0x4) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite3", "installed", "name", "BackOffice");
          if(Obj.OSProductSuite & 0x8) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite4", "installed", "name", "Communication Server");
          if(Obj.OSProductSuite & 0x10) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite5", "installed", "name", "Terminal Server");
          if(Obj.OSProductSuite & 0x20) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite6", "installed", "name", "Small Business (Restricted)");
          if(Obj.OSProductSuite & 0x40) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite7", "installed", "name", "Embedded NT");
          if(Obj.OSProductSuite & 0x80) this._xmlCreateChildTextNodeWithAttribute(xmlDoc, suite_node, "Suite8", "installed", "name", "Data Center");
        }

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectOSRecoveryInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_OSRecoveryConfiguration"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "OS Recovery Configurations");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "OS Recovery Configuration" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "AutoReboot", Obj.AutoReboot, "name", "Automatically reboot during a recovery operation");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DebugFilePath", Obj.DebugFilePath, "name", "Full path to the debug file");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DebugInfoType", this._translate_debug_info_type(Obj.DebugInfoType), "name", "Type of debugging information written to the log file");
        this._xmlCreateChildTextNode(xmlDoc, root, "Description", Obj.Description);
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "OverwriteExistingDebugFile", Obj.OverwriteExistingDebugFile, "name", "New log file will overwrite an existing one");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SendAdminAlert", Obj.SendAdminAlert, "name", "Alert message will be sent to the system administrator");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SettingID", Obj.SettingID, "name", "Seting ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "WriteDebugInfo", Obj.WriteDebugInfo, "name", "Debugging information is to be written to a log file");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "WriteToSystemLog", Obj.WriteToSystemLog, "name", "Events will be written to a system log");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectOSBootInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_BootConfiguration"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Boot Configurations");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Boot Configuration" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "BootDirectory", Obj.BootDirectory, "name", "Path to the system files required for booting the system");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ConfigurationPath", Obj.ConfigurationPath, "name", "Path to the configuration files");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Name", Obj.Name, "name", "Name of this configuration");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ScratchDirectory", Obj.ScratchDirectory, "name", "Directory where temporary files can reside during boot time");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "SettingID", Obj.SettingID, "name", "Setting ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "TempDirectory", Obj.TempDirectory, "name", "Directory where temporary files are stored");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectQFEInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_QuickFixEngineering"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "QuickFixEngineering Packs");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "QFE Pack" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNode(xmlDoc, root, "Description", Obj.Description);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "FixComments", Obj.FixComments, "name", "Comments");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "HotFixID", Obj.HotFixID, "name", "Hotfix ID");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InstallDate", this._translate_date(Obj.InstallDate), "name", "Date when hotfix was installed");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "InstalledBy", Obj.InstalledBy, "name", "Person who installed the update");
        this._xmlCreateChildTextNode(xmlDoc, root, "Name", Obj.Name);
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ServicePackInEffect", Obj.ServicePackInEffect, "name", "Service pack in effect when the update was applied");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectODBCDataSourceInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_ODBCDataSourceSpecification"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "ODBC Data Sources");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "ODBC Data Source" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CheckID", Obj.CheckID, "name", "Unique data source identifier");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DataSource", Obj.DataSource, "name", "Token name for this data source");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "DriverDescription", Obj.DriverDescription, "name", "Name of associated ODBC driver");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Registration", this._translate_odbc_registraton(Obj.Registration), "name", "Type of registration");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Version", Obj.Version, "name", "Version");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectODBCDriverInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_ODBCDriverSpecification"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "ODBC Drivers");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "ODBC Driver" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CheckID", Obj.CheckID, "name", "Unique driver identifier");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Driver", Obj.Driver, "name", "Token name for this driver");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Version", Obj.Version, "name", "Version");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectODBCTranslatorInfo = function()
  {
    var fc = new Enumerator(this._ExecQuery("Win32_ODBCTranslatorSpecification"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "ODBC Translators");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "ODBC Translator" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "CheckID", Obj.CheckID, "name", "Unique translator identifier");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Translator", Obj.Translator, "name", "Token name for this translator");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "Version", Obj.Version, "name", "Version");

        i++;
      }
    }

    return xmlDoc;
  }

  this._collectPingData = function(ip)
  {
    var local_service = GetObject("winmgmts:{impersonationLevel=impersonate}!root/cimv2")

    // WinXP/2003Server only!
    var fc = new Enumerator(local_service.ExecQuery("Select * from Win32_PingStatus where Address = '" + ip + "'"));

    var xmlDoc = null, colItem = null, numItems = 0;

    for (; !fc.atEnd(); fc.moveNext())
      numItems++;

    if(numItems > 0)
    {
      xmlDoc = new ActiveXObject("Msxml2.DOMDocument");

      if(numItems > 1)
      {
        colItem = xmlDoc.createElement("Item");
        xmlDoc.appendChild(colItem);
        this._xmlSetAttribute(xmlDoc, colItem, "name", "Ping Data Sets");
      }

      var i = 1;
      for (fc.moveFirst(); !fc.atEnd(); fc.moveNext())
      {
        var Obj = fc.item();

        var root, num = "";
        if(colItem)
        {
          root = xmlDoc.createElement("Element");
          num = " " + String(i);
        }
        else
        {
          root = xmlDoc.createElement("Item");
        }

        this._xmlSetAttribute(xmlDoc, root, "name", "Ping Data" + num);
        if(colItem)
        {
          colItem.appendChild(root);
        }
        else
        {
          xmlDoc.appendChild(root);
        }

        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "ResponseTime", Obj.ResponseTime, "name", "Response time");
        this._xmlCreateChildTextNodeWithAttribute(xmlDoc, root, "StatusCode", Obj.StatusCode, "name", "Status code returned");

        i++;
      }
    }

    return xmlDoc;
  }

  // Code translation routines:

  this._translate_date = function(date_code)
  {
    var date_str = String(date_code);

    if(this._isempty(date_str)) return "";

    var any_numbers = false;
    for(var i = 0; i < date_str.length; i++)
    {
      if(!isNaN(parseInt(date_str.charAt(i))))
      {
        any_numbers = true;
        break;
      }
    }

    if(!any_numbers) return "";

    return date_str.substring(4, 6)+"/"+date_str.substring(6, 8)+"/"+date_str.substring(0, 4)+", "+date_str.substring(8, 10)+":"+date_str.substring(10, 12)+":"+date_str.substring(12, 14);
  }

  this._translate_availability = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "Running / Full Power"; break;
      case 4: return "Warning"; break;
      case 5: return "In Test"; break;
      case 6: return "Not Applicable"; break;
      case 7: return "Power Off"; break;
      case 8: return "Off Line"; break;
      case 9: return "Off Duty"; break;
      case 10: return "Degraded"; break;
      case 11: return "Not Installed"; break;
      case 12: return "Install Error"; break;
      case 13: return "Power Save - Unknown"; break;
      case 14: return "Power Save - Low Power Mode"; break;
      case 15: return "Power Save - Standby"; break;
      case 16: return "Power Cycle"; break;
      case 17: return "Power Save - Warning"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_bios_feats = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "BIOS Characteristics Not Supported"; break;
      case 4: return "ISA is supported"; break;
      case 5: return "MCA is supported"; break;
      case 6: return "EISA is supported"; break;
      case 7: return "PCI is supported"; break;
      case 8: return "PC Card (PCMCIA) is supported"; break;
      case 9: return "Plug and Play is supported"; break;
      case 10: return "APM is supported"; break;
      case 11: return "BIOS is Upgradable (Flash)"; break;
      case 12: return "BIOS shadowing is allowed"; break;
      case 13: return "VL-VESA is supported"; break;
      case 14: return "ESCD support is available"; break;
      case 15: return "Boot from CD is supported"; break;
      case 16: return "Selectable Boot is supported"; break;
      case 17: return "BIOS ROM is socketed"; break;
      case 18: return "Boot From PC Card (PCMCIA) is supported"; break;
      case 19: return "EDD (Enhanced Disk Drive) Specification is supported"; break;
      case 20: return "Int 13h - Japanese Floppy for NEC 9800 1.2mb (3.5, 1k Bytes/Sector, 360 RPM) is supported"; break;
      case 21: return "Int 13h - Japanese Floppy for Toshiba 1.2mb (3.5, 360 RPM) is supported"; break;
      case 22: return "Int 13h - 5.25 / 360 KB Floppy Services are supported"; break;
      case 23: return "Int 13h - 5.25 /1.2MB Floppy Services are supported"; break;
      case 24: return "Int 13h - 3.5 / 720 KB Floppy Services are supported"; break;
      case 25: return "Int 13h - 3.5 / 2.88 MB Floppy Services are supported"; break;
      case 26: return "Int 5h, Print Screen Service is supported"; break;
      case 27: return "Int 9h, 8042 Keyboard services are supported"; break;
      case 28: return "Int 14h, Serial Services are supported"; break;
      case 29: return "Int 17h, printer services are supported"; break;
      case 30: return "Int 10h, CGA/Mono Video Services are supported"; break;
      case 31: return "NEC PC-98"; break;
      case 32: return "ACPI supported"; break;
      case 33: return "USB Legacy is supported"; break;
      case 34: return "AGP is supported"; break;
      case 35: return "I2O boot is supported"; break;
      case 36: return "LS-120 boot is supported"; break;
      case 37: return "ATAPI ZIP Drive boot is supported"; break;
      case 38: return "1394 boot is supported"; break;
      case 39: return "Smart Battery supported"; break;
      default: return "Reserved (" + String(code) + ")"; break;
    }
  }

  this._translate_processor_architecture = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "x86"; break;
      case 1: return "MIPS"; break;
      case 2: return "Alpha"; break;
      case 3: return "PowerPC"; break;
      case 6: return "Intel Itanium Processor Family"; break;
      case 9: return "x64"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_processor_status = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "CPU Enabled"; break;
      case 2: return "CPU Disabled by User via BIOS Setup"; break;
      case 3: return "CPU Disabled By BIOS (POST Error)"; break;
      case 4: return "CPU is Idle"; break;
      case 5:
      case 6: return "Reserved (" + String(code) + ")"; break;
      case 7: return "Other (" + String(code) + ")"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_processor_family = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "8086"; break;
      case 4: return "80286"; break;
      case 5: return "Intel386 processor"; break;
      case 6: return "Intel486 processor"; break;
      case 7: return "8087"; break;
      case 8: return "80287"; break;
      case 9: return "80387"; break;
      case 10: return "80487"; break;
      case 11: return "Pentium brand"; break;
      case 12: return "Pentium Pro"; break;
      case 13: return "Pentium II"; break;
      case 14: return "Pentium MMX"; break;
      case 15: return "Celeron"; break;
      case 16: return "Pentium II Xeon"; break;
      case 17: return "Pentium III"; break;
      case 18: return "M1 Family"; break;
      case 19: return "M2 Family"; break;
      case 24: return "AMD Duron Processor Family"; break;
      case 25: return "K5 Family"; break;
      case 26: return "K6 Family"; break;
      case 27: return "K6-2"; break;
      case 28: return "K6-3"; break;
      case 29: return "AMD Athlon Processor Family"; break;
      case 30: return "AMD2900 Family"; break;
      case 31: return "K6-2+"; break;
      case 32: return "Power PC Family"; break;
      case 33: return "Power PC 601"; break;
      case 34: return "Power PC 603"; break;
      case 35: return "Power PC 603+"; break;
      case 36: return "Power PC 604"; break;
      case 37: return "Power PC 620"; break;
      case 38: return "Power PC X704"; break;
      case 39: return "Power PC 750"; break;
      case 48: return "Alpha Family"; break;
      case 49: return "Alpha 21064"; break;
      case 50: return "Alpha 21066"; break;
      case 51: return "Alpha 21164"; break;
      case 52: return "Alpha 21164PC"; break;
      case 53: return "Alpha 21164a"; break;
      case 54: return "Alpha 21264"; break;
      case 55: return "Alpha 21364"; break;
      case 64: return "MIPS Family"; break;
      case 65: return "MIPS R4000"; break;
      case 66: return "MIPS R4200"; break;
      case 67: return "MIPS R4400"; break;
      case 68: return "MIPS R4600"; break;
      case 69: return "MIPS R10000"; break;
      case 80: return "SPARC Family"; break;
      case 81: return "SuperSPARC"; break;
      case 82: return "microSPARC II"; break;
      case 83: return "microSPARC IIep"; break;
      case 84: return "UltraSPARC"; break;
      case 85: return "UltraSPARC II"; break;
      case 86: return "UltraSPARC IIi"; break;
      case 87: return "UltraSPARC III"; break;
      case 88: return "UltraSPARC IIIi"; break;
      case 96: return "68040"; break;
      case 97: return "68xxx Family"; break;
      case 98: return "68000"; break;
      case 99: return "68010"; break;
      case 100: return "68020"; break;
      case 101: return "68030"; break;
      case 112: return "Hobbit Family"; break;
      case 120: return "Crusoe TM5000 Family"; break;
      case 121: return "Crusoe TM3000 Family"; break;
      case 122: return "Efficeon TM8000 Family"; break;
      case 128: return "Weitek"; break;
      case 130: return "Itanium Processor"; break;
      case 131: return "AMD Athlon 64 Processor Famiily"; break;
      case 132: return "AMD Opteron Processor Family"; break;
      case 144: return "PA-RISC Family"; break;
      case 145: return "PA-RISC 8500"; break;
      case 146: return "PA-RISC 8000"; break;
      case 147: return "PA-RISC 7300LC"; break;
      case 148: return "PA-RISC 7200"; break;
      case 149: return "PA-RISC 7100LC"; break;
      case 150: return "PA-RISC 7100"; break;
      case 160: return "V30 Family"; break;
      case 176: return "Pentium III Xeon processor"; break;
      case 177: return "Pentium III Processor with Intel SpeedStep Technology"; break;
      case 178: return "Pentium 4"; break;
      case 179: return "Intel Xeon"; break;
      case 180: return "AS400 Family"; break;
      case 181: return "Intel Xeon processor MP"; break;
      case 182: return "AMD Athlon XP Family"; break;
      case 183: return "AMD Athlon MP Family"; break;
      case 184: return "Intel Itanium 2"; break;
      case 185: return "Intel Pentium M Processor"; break;
      case 190: return "K7"; break;
      case 200: return "IBM390 Family"; break;
      case 201: return "G4"; break;
      case 202: return "G5"; break;
      case 203: return "G6"; break;
      case 204: return "z/Architecture base"; break;
      case 250: return "i860"; break;
      case 251: return "i960"; break;
      case 260: return "SH-3"; break;
      case 261: return "SH-4"; break;
      case 280: return "ARM"; break;
      case 281: return "StrongARM"; break;
      case 300: return "6x86"; break;
      case 301: return "MediaGX"; break;
      case 302: return "MII"; break;
      case 320: return "WinChip"; break;
      case 350: return "DSP"; break;
      case 500: return "Video Processor"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_processor_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "Central Processor"; break;
      case 4: return "Math Processor"; break;
      case 5: return "DSP Processor"; break;
      case 6: return "Video Processor"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_memory_form_factor = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Unknown (" + String(code) + ")"; break;
      case 2: return "SIP"; break;
      case 3: return "DIP"; break;
      case 4: return "ZIP"; break;
      case 5: return "SOJ"; break;
      case 6: return "Proprietary"; break;
      case 7: return "SIMM"; break;
      case 8: return "DIMM"; break;
      case 9: return "TSOP"; break;
      case 10: return "PGA"; break;
      case 11: return "RIMM"; break;
      case 12: return "SODIMM"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_memory_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Unknown (" + String(code) + ")"; break;
      case 2: return "DRAM"; break;
      case 3: return "Synchronous DRAM"; break;
      case 4: return "Cache DRAM"; break;
      case 5: return "EDO"; break;
      case 6: return "EDRAM"; break;
      case 7: return "VRAM"; break;
      case 8: return "SRAM"; break;
      case 9: return "RAM"; break;
      case 10: return "ROM"; break;
      case 11: return "Flash"; break;
      case 12: return "EEPROM"; break;
      case 13: return "FEPROM"; break;
      case 14: return "EPROM"; break;
      case 15: return "CDRAM"; break;
      case 16: return "3DRAM"; break;
      case 17: return "SDRAM"; break;
      case 18: return "SGRAM"; break;
      case 19: return "RDRAM"; break;
      case 20: return "DDR"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_video_memory_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "VRAM"; break;
      case 4: return "DRAM"; break;
      case 5: return "SRAM"; break;
      case 6: return "WRAM"; break;
      case 7: return "EDO RAM"; break;
      case 8: return "Burst Synchronous DRAM"; break;
      case 9: return "Pipelined Burst SRAM"; break;
      case 10: return "CDRAM"; break;
      case 11: return "3DRAM"; break;
      case 12: return "SDRAM"; break;
      case 13: return "SGRAM"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_scsi_protection_management = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "Unprotected"; break;
      case 4: return "Protected"; break;
      case 5: return "Protected through SCC (SCSI-3 Controller Command)"; break;
      case 6: return "Protected through SCC-2 (SCSI-3 Controller Command)"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_protocol_supported = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "EISA"; break;
      case 4: return "ISA"; break;
      case 5: return "PCI"; break;
      case 6: return "ATA/ATAPI"; break;
      case 7: return "Flexible Diskette"; break;
      case 8: return "1496"; break;
      case 9: return "SCSI Parallel Interface"; break;
      case 10: return "SCSI Fibre Channel Protocol"; break;
      case 11: return "SCSI Serial Bus Protocol"; break;
      case 12: return "SCSI Serial Bus Protocol-2 (1394)"; break;
      case 13: return "SCSI Serial Storage Architecture"; break;
      case 14: return "VESA"; break;
      case 15: return "PCMCIA"; break;
      case 16: return "Universal Serial Bus"; break;
      case 17: return "Parallel Protocol"; break;
      case 18: return "ESCON"; break;
      case 19: return "Diagnostic"; break;
      case 20: return "I2C"; break;
      case 21: return "Power"; break;
      case 22: return "HIPPI"; break;
      case 23: return "MultiBus"; break;
      case 24: return "VME"; break;
      case 25: return "IPI"; break;
      case 26: return "IEEE-488"; break;
      case 27: return "RS232"; break;
      case 28: return "IEEE 802.3 10BASE5"; break;
      case 29: return "IEEE 802.3 10BASE2"; break;
      case 30: return "IEEE 802.3 1BASE5"; break;
      case 31: return "IEEE 802.3 10BROAD36"; break;
      case 32: return "IEEE 802.3 100BASEVG"; break;
      case 33: return "IEEE 802.5 Token-Ring"; break;
      case 34: return "ANSI X3T9.5 FDDI"; break;
      case 35: return "MCA"; break;
      case 36: return "ESDI"; break;
      case 37: return "IDE"; break;
      case 38: return "CMD"; break;
      case 39: return "ST506"; break;
      case 40: return "DSSI"; break;
      case 41: return "QIC2"; break;
      case 42: return "Enhanced ATA/IDE"; break;
      case 43: return "AGP"; break;
      case 44: return "TWIRP (two-way infrared)"; break;
      case 45: return "FIR (fast infrared)"; break;
      case 46: return "SIR (serial infrared)"; break;
      case 47: return "IrBus"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_net_connection_status = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Disconnected"; break;
      case 1: return "Connecting"; break;
      case 2: return "Connected"; break;
      case 3: return "Disconnecting"; break;
      case 4: return "Hardware not present"; break;
      case 5: return "Hardware disabled"; break;
      case 6: return "Hardware malfunction"; break;
      case 7: return "Media disconnected"; break;
      case 8: return "Authenticating"; break;
      case 9: return "Authentication succeeded"; break;
      case 10: return "Authentication failed"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_video_architecture = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "CGA"; break;
      case 4: return "EGA"; break;
      case 5: return "VGA"; break;
      case 6: return "SVGA"; break;
      case 7: return "MDA"; break;
      case 8: return "HGC"; break;
      case 9: return "MCGA"; break;
      case 10: return "8514A"; break;
      case 11: return "XGA"; break;
      case 12: return "Linear Frame Buffer"; break;
      case 160: return "PC-98"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_mouse_interface = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "Serial"; break;
      case 4: return "PS/2"; break;
      case 5: return "Infrared"; break;
      case 6: return "HP-HIL"; break;
      case 7: return "Bus mouse"; break;
      case 8: return "ADB (Apple Desktop Bus)"; break;
      case 160: return "Bus mouse DB-9"; break;
      case 161: return "Bus mouse micro-DIN"; break;
      case 162: return "USB"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_mouse_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "Mouse"; break;
      case 4: return "Track Ball"; break;
      case 5: return "Track Point"; break;
      case 6: return "Glide Point"; break;
      case 7: return "Touch Pad"; break;
      case 8: return "Touch Screen"; break;
      case 9: return "Mouse - Optical Sensor"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_printer_status = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Unknown (" + String(code) + ")"; break;
      case 3: return "Idle"; break;
      case 4: return "Printing"; break;
      case 5: return "Warmup"; break;
      case 6: return "Stopped printing"; break;
      case 7: return "Offline"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_software_install_state = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case -6: return "Bad Configuration"; break;
      case -2: return "Invalid Argument"; break;
      case -1: return "Unknown Package"; break;
      case 1: return "Advertised"; break;
      case 2: return "Absent"; break;
      case 5: return "Installed"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_logon_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2:
      case "Interactive":
        return "Interactive user logon (incl. terminal server/remote shell sessions)"; break;

      case 3:
      case "Network":
        return "Used by high performance servers to authenticate clear text passwords"; break;

      case 4:
      case "Batch":
        return "Batch server/high performance (mail or web) server logon"; break;

      case 5:
      case "Service":
        return "Service-type logon"; break;

      case 6:
      case "Proxy":
        return "Proxy-type logon"; break;

      case 7:
      case "Unlock":
        return "Intended for GINA DLLs logging on users who will be interactively using the machine (audit-related)"; break;

      case 8:
      case "NetworkCleartext":
        return "(Windows 2000/XP/.NET Server 2003 family) Preserves the name and password in the authentication packages, allowing the server to make connections to other network servers while impersonating the client"; break;

      case 9:
      case "NewCredentials":
        return "(Windows 2000/XP/.NET Server 2003 family) Allows the caller to clone its current token and specify new credentials for outbound connections"; break;

      case 10:
      case "RemoteInteractive":
        return "Terminal Server session that is both remote and interactive"; break;

      case 11:
      case "CachedInteractive":
        return "Attempt cached credentials without accessing the network"; break;

      case 12:
      case "CachedRemoteInteractive":
        return "Terminal Server session that is both remote and interactive (used for internal auditing)"; break;

      case 13:
      case "CachedUnlock":
        return "Workstation logon"; break;

      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_user_account_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 256: return "Local user account for user who has a primary account in another domain"; break;
      case 512: return "Default account type that represents a typical user"; break;
      case 2048: return "Account for a system domain that trusts other domains"; break;
      case 4096: return "Computer account for a Windows NT/Windows 2000 machine that is a member of this domain"; break;
      case 8192: return "Account for a system backup domain controller that is a member of this domain"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_privilege = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Guest"; break;
      case 1: return "User"; break;
      case 2: return "Administrator"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_pass_age = function(age)
  {
    if(String(age).indexOf(".") != -1)
    {
      var ages = String(age);
      var yrs = parseInt(ages.substring(0, 4)), mnths = parseInt(ages.substring(4, 6)),
           ds = parseInt(ages.substring(6, 8)),   hrs = parseInt(ages.substring(8, 10)),
           mn = parseInt(ages.substring(10, 12));

      return ((yrs > 0) ? yrs + " years" + ((mnths > 0) || (ds > 0) || (hrs > 0) || (mn > 0) ? ", " : "") : "") +
             ((mnths > 0) ? mnths + " months" + ((ds > 0) || (hrs > 0) || (mn > 0) ? ", " : "") : "") +
             ((ds > 0) ? ds + " days" + ((hrs > 0) || (mn > 0) ? ", " : "") : "") +
             ((hrs > 0) ? hrs + " hours" + ((mn > 0) ? ", " : "") : "") +
             ((mn > 0) ? mn + " minutes" : "");
    }
    else
      return age;
  }

  this._translate_application_boost = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "None"; break;
      case 1: return "Minimum"; break;
      case 2: return "Maximum"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_type_of_os = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Other"; break;
      case 2: return "MACOS"; break;
      case 3: return "ATTUNIX"; break;
      case 4: return "DGUX"; break;
      case 5: return "DECNT"; break;
      case 6: return "Digital Unix"; break;
      case 7: return "OpenVMS"; break;
      case 8: return "HPUX"; break;
      case 9: return "AIX"; break;
      case 10: return "MVS"; break;
      case 11: return "OS400"; break;
      case 12: return "OS/2"; break;
      case 13: return "JavaVM"; break;
      case 14: return "MSDOS"; break;
      case 15: return "WIN3x"; break;
      case 16: return "WIN95"; break;
      case 17: return "WIN98"; break;
      case 18: return "WINNT"; break;
      case 19: return "WINCE"; break;
      case 20: return "NCR3000"; break;
      case 21: return "NetWare"; break;
      case 22: return "OSF"; break;
      case 23: return "DC/OS"; break;
      case 24: return "Reliant UNIX"; break;
      case 25: return "SCO UnixWare"; break;
      case 26: return "SCO OpenServer"; break;
      case 27: return "Sequent"; break;
      case 28: return "IRIX"; break;
      case 29: return "Solaris"; break;
      case 30: return "SunOS"; break;
      case 31: return "U6000"; break;
      case 32: return "ASERIES"; break;
      case 33: return "TandemNSK"; break;
      case 34: return "TandemNT"; break;
      case 35: return "BS2000"; break;
      case 36: return "LINUX"; break;
      case 37: return "Lynx"; break;
      case 38: return "XENIX"; break;
      case 39: return "VM/ESA"; break;
      case 40: return "Interactive UNIX"; break;
      case 41: return "BSDUNIX"; break;
      case 42: return "FreeBSD"; break;
      case 43: return "NetBSD"; break;
      case 44: return "GNU Hurd"; break;
      case 45: return "OS9"; break;
      case 46: return "MACH Kernel"; break;
      case 47: return "Inferno"; break;
      case 48: return "QNX"; break;
      case 49: return "EPOC"; break;
      case 50: return "IxWorks"; break;
      case 51: return "VxWorks"; break;
      case 52: return "MiNT"; break;
      case 53: return "BeOS"; break;
      case 54: return "HP MPE"; break;
      case 55: return "NextStep"; break;
      case 56: return "PalmPilot"; break;
      case 57: return "Rhapsody"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_language_of_os = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0x0001: return "Arabic"; break;
      case 0x0004: return "Chinese"; break;
      case 0x0009: return "English"; break;
      case 0x0401: return "Arabic (Saudi Arabia)"; break;
      case 0x0402: return "Bulgarian"; break;
      case 0x0403: return "Catalan"; break;
      case 0x0404: return "Chinese (Taiwan)"; break;
      case 0x0405: return "Czech"; break;
      case 0x0406: return "Danish"; break;
      case 0x0407: return "German (Germany)"; break;
      case 0x0408: return "Greek"; break;
      case 0x0409: return "English (United States)"; break;
      case 0x040A: return "Spanish (Traditional Sort)"; break;
      case 0x040B: return "Finnish"; break;
      case 0x040C: return "French (France)"; break;
      case 0x040D: return "Hebrew"; break;
      case 0x040E: return "Hungarian"; break;
      case 0x040F: return "Icelandic"; break;
      case 0x0410: return "Italian (Italy)"; break;
      case 0x0411: return "Japanese"; break;
      case 0x0412: return "Korean"; break;
      case 0x0413: return "Dutch (Netherlands)"; break;
      case 0x0414: return "Norwegian (Bokmal)"; break;
      case 0x0415: return "Polish"; break;
      case 0x0416: return "Portuguese (Brazil)"; break;
      case 0x0417: return "Rhaeto-Romanic"; break;
      case 0x0418: return "Romanian"; break;
      case 0x0419: return "Russian"; break;
      case 0x041A: return "Croatian"; break;
      case 0x041B: return "Slovak"; break;
      case 0x041C: return "Albanian"; break;
      case 0x041D: return "Swedish"; break;
      case 0x041E: return "Thai"; break;
      case 0x041F: return "Turkish"; break;
      case 0x0420: return "Urdu"; break;
      case 0x0421: return "Indonesian"; break;
      case 0x0422: return "Ukrainian"; break;
      case 0x0423: return "Belarusian"; break;
      case 0x0424: return "Slovenian"; break;
      case 0x0425: return "Estonian"; break;
      case 0x0426: return "Latvian"; break;
      case 0x0427: return "Lithuanian"; break;
      case 0x0429: return "Farsi"; break;
      case 0x042A: return "Vietnamese"; break;
      case 0x042D: return "Basque"; break;
      case 0x042E: return "Sorbian"; break;
      case 0x042F: return "Macedonian (FYROM)"; break;
      case 0x0430: return "Sutu"; break;
      case 0x0431: return "Tsonga"; break;
      case 0x0432: return "Tswana"; break;
      case 0x0434: return "Xhosa"; break;
      case 0x0435: return "Zulu"; break;
      case 0x0436: return "Afrikaans"; break;
      case 0x0438: return "Faeroese"; break;
      case 0x0439: return "Hindi"; break;
      case 0x043A: return "Maltese"; break;
      case 0x043C: return "Gaelic"; break;
      case 0x043D: return "Yiddish"; break;
      case 0x043E: return "Malay (Malaysia)"; break;
      case 0x0801: return "Arabic (Iraq)"; break;
      case 0x0804: return "Chinese (PRC)"; break;
      case 0x0807: return "German (Switzerland)"; break;
      case 0x0809: return "English (United Kingdom)"; break;
      case 0x080A: return "Spanish (Mexico)"; break;
      case 0x080C: return "French (Belgium)"; break;
      case 0x0810: return "Italian (Switzerland)"; break;
      case 0x0813: return "Dutch (Belgium)"; break;
      case 0x0814: return "Norwegian (Nynorsk)"; break;
      case 0x0816: return "Portuguese (Portugal)"; break;
      case 0x0818: return "Romanian (Moldova)"; break;
      case 0x0819: return "Russian (Moldova)"; break;
      case 0x081A: return "Serbian (Latin)"; break;
      case 0x081D: return "Swedish (Finland)"; break;
      case 0x0C01: return "Arabic (Egypt)"; break;
      case 0x0C04: return "Chinese (Hong Kong SAR)"; break;
      case 0x0C07: return "German (Austria)"; break;
      case 0x0C09: return "English (Australia)"; break;
      case 0x0C0A: return "Spanish (International Sort)"; break;
      case 0x0C0C: return "French (Canada)"; break;
      case 0x0C1A: return "Serbian (Cyrillic)"; break;
      case 0x1001: return "Arabic (Libya)"; break;
      case 0x1004: return "Chinese (Singapore)"; break;
      case 0x1007: return "German (Luxembourg)"; break;
      case 0x1009: return "English (Canada)"; break;
      case 0x100A: return "Spanish (Guatemala)"; break;
      case 0x100C: return "French (Switzerland)"; break;
      case 0x1401: return "Arabic (Algeria)"; break;
      case 0x1407: return "German (Liechtenstein)"; break;
      case 0x1409: return "English (New Zealand)"; break;
      case 0x140A: return "Spanish (Costa Rica)"; break;
      case 0x140C: return "French (Luxembourg)"; break;
      case 0x1801: return "Arabic (Morocco)"; break;
      case 0x1809: return "English (Ireland)"; break;
      case 0x180A: return "Spanish (Panama)"; break;
      case 0x1C01: return "Arabic (Tunisia)"; break;
      case 0x1C09: return "English (South Africa)"; break;
      case 0x1C0A: return "Spanish (Dominican Republic)"; break;
      case 0x2001: return "Arabic (Oman)"; break;
      case 0x2009: return "English (Jamaica)"; break;
      case 0x200A: return "Spanish (Venezuela)"; break;
      case 0x2401: return "Arabic (Yemen)"; break;
      case 0x240A: return "Spanish (Colombia)"; break;
      case 0x2801: return "Arabic (Syria)"; break;
      case 0x2809: return "English (Belize)"; break;
      case 0x280A: return "Spanish (Peru)"; break;
      case 0x2C01: return "Arabic (Jordan)"; break;
      case 0x2C09: return "English (Trinidad)"; break;
      case 0x2C0A: return "Spanish (Argentina)"; break;
      case 0x3001: return "Arabic (Lebanon)"; break;
      case 0x300A: return "Spanish (Ecuador)"; break;
      case 0x3401: return "Arabic (Kuwait)"; break;
      case 0x340A: return "Spanish (Chile)"; break;
      case 0x3801: return "Arabic (U.A.E.)"; break;
      case 0x380A: return "Spanish (Uruguay)"; break;
      case 0x3C01: return "Arabic (Bahrain)"; break;
      case 0x3C0A: return "Spanish (Paraguay)"; break;
      case 0x4001: return "Arabic (Qatar)"; break;
      case 0x400A: return "Spanish (Bolivia)"; break;
      case 0x440A: return "Spanish (El Salvador)"; break;
      case 0x480A: return "Spanish (Honduras)"; break;
      case 0x4C0A: return "Spanish (Nicaragua)"; break;
      case 0x500A: return "Spanish (Puerto Rico)"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_domain_role = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Standalone Workstation"; break;
      case 1: return "Member Workstation"; break;
      case 2: return "Standalone Server"; break;
      case 3: return "Member Server"; break;
      case 4: return "Backup Domain Controller"; break;
      case 5: return "Primary Domain Controller"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_power_state = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Full Power"; break;
      case 2: return "Power Save - Low Power Mode"; break;
      case 3: return "Power Save - Standby"; break;
      case 4: return "Power Save - Unknown"; break;
      case 5: return "Power Cycle"; break;
      case 6: return "Power Off"; break;
      case 7: return "Power Save - Warning"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_power_supply_state = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Other"; break;
      case 3: return "Safe"; break;
      case 4: return "Warning"; break;
      case 5: return "Critical"; break;
      case 6: return "Non-recoverable"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_wake_up = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Reserved"; break;
      case 1: return "Other"; break;
      case 3: return "APM Timer"; break;
      case 4: return "Modem Ring"; break;
      case 5: return "LAN Remote"; break;
      case 6: return "Power Switch"; break;
      case 7: return "PCI PME#"; break;
      case 8: return "AC Power Restored"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_debug_info_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "None"; break;
      case 1: return "Complete memory dump"; break;
      case 2: return "Kernel memory dump"; break;
      case 3: return "Small memory dump"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_odbc_registraton = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Per machine"; break;
      case 1: return "Per user"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_true_false = function(code)
  {
    if(this._isempty(code)) return "";

    return (code == 1) ? "True" : "False";
  }

  this._translate_conseq_capabilities = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Other"; break;
      case 2: return "Sequential Access"; break;
      case 3: return "Random Access"; break;
      case 4: return "Supports Writing"; break;
      case 5: return "Encryption"; break;
      case 6: return "Compression"; break;
      case 7: return "Supports Removable Media"; break;
      case 8: return "Manual Cleaning"; break;
      case 9: return "Automatic Cleaning"; break;
      case 10: return "SMART Notification"; break;
      case 11: return "Supports Dual Sided Media"; break;
      case 12: return "Predismount Eject Not Required"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_answer_mode = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 2: return "Other"; break;
      case 3: return "Disabled"; break;
      case 4: return "Manual Answer"; break;
      case 5: return "Auto Answer"; break;
      case 6: return "Auto Answer with Call-Back"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_dial_tone = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Tone"; break;
      case 2: return "Pulse"; break;
      default: return "Unknown (" + String(code) + ")"; break;
    }
  }

  this._translate_modem_port = function(code)
  {
    if(this._isempty(code)) return "";

    switch(parseInt(code.charAt(2)))
    {
      case 0: return "Parallel Port"; break;
      case 1: return "Serial Port"; break;
      case 2: return "Modem"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_print_color = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Monochrome"; break;
      case 2: return "Color"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_print_dither_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "No Dithering"; break;
      case 2: return "Coarse Brush"; break;
      case 3: return "Fine Brush"; break;
      case 4: return "Line Art"; break;
      case 5: return "Greyscale"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_print_icm_intent = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Saturation"; break;
      case 2: return "Contrast"; break;
      case 3: return "Exact Color"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_print_icm_method = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Disabled"; break;
      case 2: return "Windows"; break;
      case 3: return "Device Driver"; break;
      case 4: return "Device"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_print_media_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Standard"; break;
      case 2: return "Transparency"; break;
      case 3: return "Glossy"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_print_orientation = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "Portrait"; break;
      case 2: return "Landscape"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_print_true_type_option = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 1: return "TrueType fonts as graphics"; break;
      case 2: return "TrueType fonts as soft fonts (PCL printers)"; break;
      case 3: return "Substitute device fonts for TrueType fonts"; break;
      default: return "Other (" + String(code) + ")";
    }
  }

  this._translate_service_philosophy = function(code)
  {
    if(this._isempty(code)) return "";

    switch(code)
    {
      case 0: return "Unknown"; break;
      case 2: return "Service From Top"; break;
      case 3: return "Service From Front"; break;
      case 4: return "Service From Back"; break;
      case 5: return "Service From Side"; break;
      case 6: return "Sliding Trays"; break;
      case 7: return "Removable Sides"; break;
      case 8: return "Moveable"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }

  this._translate_chassis_type = function(code)
  {
    if(this._isempty(code)) return "";

    switch(Number(code))
    {
      case 2:  return "Unknown"; break;
      case 3:  return "Desktop"; break;
      case 4:  return "Low Profile Desktop"; break;
      case 5:  return "Pizza Box"; break;
      case 6:  return "Mini Tower"; break;
      case 7:  return "Tower"; break;
      case 8:  return "Portable"; break;
      case 9:  return "Laptop"; break;
      case 10: return "Notebook"; break;
      case 11: return "Hand Held"; break;
      case 12: return "Docking Station"; break;
      case 13: return "All in One"; break;
      case 14: return "Sub Notebook"; break;
      case 15: return "Space-Saving"; break;
      case 16: return "Lunch Box"; break;
      case 17: return "Main System Chassis"; break;
      case 18: return "Expansion Chassis"; break;
      case 19: return "SubChassis"; break;
      case 20: return "Bus Expansion Chassis"; break;
      case 21: return "Peripheral Chassis"; break;
      case 22: return "Storage Chassis"; break;
      case 23: return "Rack Mount Chassis"; break;
      case 24: return "Sealed-Case PC"; break;
      default: return "Other (" + String(code) + ")"; break;
    }
  }
};